-- CREATE DATABASE db_raw;  -- This will create the database if it does not exist already
SELECT 'CREATE DATABASE db_raw'
WHERE NOT EXISTS (SELECT FROM pg_database WHERE datname = 'db_raw')\gexec

-- CREATE DATABASE db_analysis;  -- This will create the database if it does not exist already
SELECT 'CREATE DATABASE db_analysis'
WHERE NOT EXISTS (SELECT FROM pg_database WHERE datname = 'db_analysis')\gexec


-- Connect to the database and create a table for raw data
\c db_raw;

-- Create a table for sales raw data
DROP TABLE IF EXISTS sales_data;
CREATE TABLE IF NOT EXISTS sales_data (
    invoice_no VARCHAR(255), 
    customer_id VARCHAR(255), 
    category VARCHAR(255), 
    quantity INTEGER, 
    price DECIMAL(10,2), 
    invoice_date DATE, 
    shopping_mall VARCHAR(255)
);

-- Read data from a CSV file into the table
SELECT * FROM sales_data;

-- Connect to datbase and create table for analysis data
\c db_analysis;

-- Create a table for total sales data
DROP TABLE IF EXISTS total_sales;
CREATE TABLE IF NOT EXISTS total_sales (
    id bigint GENERATED BY DEFAULT AS IDENTITY, 
    total_sales DECIMAL(10,2),
    insertion_date TIMESTAMP DEFAULT NOW()
);

-- Select total sales data into the table
SELECT * FROM total_sales;





