-- CREATE DATABASE soscon;  -- This will create the database if it does not exist already
SELECT 'CREATE DATABASE soscon'
WHERE NOT EXISTS (SELECT FROM pg_database WHERE datname = 'soscon')\gexec


-- Connect to the database and create a table for raw data
\c soscon;

-- Create a table for sales daily raw data
DROP TABLE IF EXISTS sales_daily_data;
CREATE TABLE IF NOT EXISTS sales_daily_data (
    invoice_no VARCHAR(255), 
    customer_id VARCHAR(255), 
    category VARCHAR(255), 
    quantity INTEGER, 
    price DECIMAL(10,2), 
    invoice_date DATE, 
    shopping_mall VARCHAR(255)
);

-- Create a table for customer data
DROP TABLE IF EXISTS customer_data;
CREATE TABLE IF NOT EXISTS customer_data (
    customer_id VARCHAR(255), 
    gender VARCHAR(255), 
    age INTEGER, 
    payment_method VARCHAR(255)
);

DROP TABLE IF EXISTS daily_total_sales_per_payment_method;
CREATE TABLE IF NOT EXISTS daily_total_sales_per_payment_method (
    invoice_date DATE,
    payment_method VARCHAR(255),
    total_sales DECIMAL(10,2)
);