# Include all imports
import pandas as pd
import psycopg2
from airflow import DAG
from airflow.models import Variable
from airflow.providers.standard.operators.bash import BashOperator
from airflow.providers.standard.operators.python import PythonOperator
from airflow.providers.common.sql.operators.sql import SQLExecuteQueryOperator


#------------------------ BashOperator A --------------------------------

# Add this somewhere in your code and NOT inside an operator
HOME_DIR = "/opt/airflow/dags"

# Include this is your Operator
bash_command=f"cp -r {HOME_DIR}/data/data_source/sales/ {HOME_DIR}/data/project/sales/"


#------------------------ PythonOperator A --------------------------------

DB_CONN = lambda db="db_raw": psycopg2.connect(
    host="soscon-postgres-1", database=db, user="airflow", password="airflow"
)

def ingest_data():
    conn = DB_CONN()
    try:
        cursor = conn.cursor()
        sales_df = pd.read_csv(f"{HOME_DIR}/data/project/sales/sales_data.csv")
        cursor.execute("TRUNCATE TABLE sales_data")
        cursor.executemany(
            "INSERT INTO sales_data VALUES (%s,%s,%s,%s,%s,%s,%s)",
            [tuple(row) for row in sales_df.values],
        )
        conn.commit()
    finally:
        conn.close()


#------------------------ PythonOperator C --------------------------------

def compute_total_sales():
    conn = DB_CONN()
    try:
        cursor = conn.cursor()
        cursor.execute("SELECT SUM(price*quantity) FROM sales_data")
        total_sales = cursor.fetchone()[0]
        print(f"Total Sales: {total_sales}")
        return total_sales
    finally: conn.close()

#------------------------ SQLExecuteQueryOperator --------------------------------

sql=[
    "TRUNCATE TABLE total_sales",
    "INSERT INTO total_sales (total_sales) VALUES ({{ ti.xcom_pull(task_ids='compute_total_sales') }})",
]

#-------------------------------------------------------
########################################################
#------------------------ BranchOperator  --------------------------------

from airflow.providers.standard.operators.python import PythonOperator, BranchPythonOperator, ShortCircuitOperator
from airflow.providers.standard.operators.empty import EmptyOperator


## BRANCHING OPERATOR
task1 = PythonOperator(task_id='task1', python_callable=lambda: True)
task2 = EmptyOperator(task_id='task2')
task3 = EmptyOperator(task_id='task3')

# Define branching logic
def branch_logic(**kwargs):
    if kwargs['ti'].xcom_pull(task_ids='task1') == '':
        return 'task2'
    return 'task3'

branch_task = BranchPythonOperator(
    task_id='branch_task',
    python_callable=branch_logic,
)

# Define dependencies
task1 >> branch_task >> task2
task1 >> branch_task >> task3


#------------------------ SHORTCIRCUIT OPERATOR A --------------------------------

## SHORTCIRCUIT OPERATOR
task4= EmptyOperator(task_id='task4')
task5 = EmptyOperator(task_id='task5')
task6 = EmptyOperator(task_id='task6')

# Define condition
def check_condition_true():
    return True  # Condition to skip downstream tasks

short_circuit_task_true = ShortCircuitOperator(
    task_id='short_circuit_task_true',
    python_callable=check_condition_true,
)

# Define dependencies
task4 >> short_circuit_task_true >> task5
short_circuit_task_true >> task6


#------------------------ SHORTCIRCUIT OPERATOR B --------------------------------

task7= EmptyOperator(task_id='task7')
task8 = EmptyOperator(task_id='task8')
task9 = EmptyOperator(task_id='task9')

# Define condition
def check_condition_false():
    return False  # Condition to skip downstream tasks

short_circuit_task_false = ShortCircuitOperator(
    task_id='short_circuit_task_false',
    python_callable=check_condition_false,
)

# Define dependencies
task7 >> short_circuit_task_false >> task8
short_circuit_task_false >> task9


